package org.quidity.demo.activity;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.larswerkman.holocolorpicker.ColorPicker;
import com.larswerkman.holocolorpicker.OpacityBar;
import com.larswerkman.holocolorpicker.SVBar;
import com.larswerkman.holocolorpicker.SaturationBar;
import com.larswerkman.holocolorpicker.ValueBar;

import org.quidity.demo.R;
import org.quidity.demo.util.AppUtil;

public class ColorPickerActivity extends Activity {

    public static final String SELECTED_COLOR = "SelectedColor";
    public static final String CURRENT_COLOR = "CurrentColor";

    private ColorPicker colorPicker;
    private SVBar svBar;
    //private SaturationBar saturationBar;
    //private ValueBar valueBar;
    //private OpacityBar opacityBar;
    private Button doneButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_color_picker);

        AppUtil.initActivity(this);

        colorPicker = (ColorPicker)findViewById(R.id.picker);
        svBar = (SVBar)findViewById(R.id.sv_bar);
        //saturationBar = (SaturationBar)findViewById(R.id.saturation_bar);
        //valueBar = (ValueBar)findViewById(R.id.value_bar);
        //opacityBar = (OpacityBar)findViewById(R.id.opacity_bar);
        doneButton = (Button)findViewById(R.id.done);

        colorPicker.addSVBar(svBar);
        //colorPicker.addSaturationBar(saturationBar);
        //colorPicker.addValueBar(valueBar);
        //colorPicker.addOpacityBar(opacityBar);

        colorPicker.setShowOldCenterColor(false);

        doneButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onColorSelected();
            }
        });

        int currentIntColor = getIntent().getIntExtra(CURRENT_COLOR, Color.WHITE);
        colorPicker.setColor(currentIntColor);
    }

    private void onColorSelected() {
        int intColor = colorPicker.getColor();
        Log.d(getClass().getCanonicalName(), "intColor " + intColor);

        //String hexColor = String.format("#%06X", (0xFFFFFF & intColor));
        //Log.d(getClass().getCanonicalName(), "intColor " + "hexColor " + hexColor);

        Intent data = new Intent();
        data.putExtra(SELECTED_COLOR, intColor);
        setResult(RESULT_OK, data);
        finish();
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_color_picker, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
