package org.quidity.demo.activity;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;

import org.quidity.demo.Session;

import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;


public class BaseLayerActivity extends ListActivity {

    private List<Layer> baseLayers;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        AppUtil.initActivity(this);

        determineBaseLayers();

        ListAdapter adapter = new ArrayAdapter<Layer>(this, android.R.layout.simple_list_item_single_choice, baseLayers);
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        Session session = Session.getSession();
        int currentBaseLayerIndex = session.getLayers().indexOf(session.getCurrentBaseLayer());
        getListView().setItemChecked(currentBaseLayerIndex, true);
    }

    private void determineBaseLayers() {
        baseLayers = new ArrayList<Layer>();

        for(Layer layer : Session.getSession().getLayers()) {
            if (layer.getBaseLayer()) {
                baseLayers.add(layer);
            }
        }
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        Layer selectedLayer = baseLayers.get(position);

        Session.getSession().setCurrentBaseLayer(selectedLayer);
        finish();
    }
}
