package org.quidity.demo.activity;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.mapi.attributes.Attachment;
import org.quidity.demo.mapi.attributes.AttributesByPrimaryIdRequest;
import org.quidity.demo.mapi.attributes.AttributesService;
import org.quidity.demo.mapi.attributes.Feature;
import org.quidity.demo.mapi.attributes.FeaturesResponse;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AttachmentsActivity extends ListActivity implements AdapterView.OnItemClickListener, AttributesService.FeaturesListener {

    private static final String SOURCE_IMAGE_NEW = "New Image";
    private static final String SOURCE_IMAGE_EXISTING = "Existing Image";
    private static final String SOURCE_TEXT_NEW = "New Text";
    private static final String SOURCE_AUDIO_NEW = "New Audio";
    private static final String SOURCE_AUDIO_EXISTING = "Existing Audio";
    private static final String SOURCE_VIDEO_NEW = "New Video";
    private static final String SOURCE_VIDEO_EXISTING = "Existing Video";

    private static final int REQUEST_IMAGE_NEW = 100;
    private static final int REQUEST_IMAGE_EXISTING = 200;
    private static final int REQUEST_TEXT_NEW = 300;
    private static final int REQUEST_AUDIO_NEW = 400;
    private static final int REQUEST_AUDIO_EXISTING = 500;
    private static final int REQUEST_VIDEO_NEW = 600;
    private static final int REQUEST_VIDEO_EXISTING = 700;

    private static final int REQUEST_VIEW = 800;
    private static final int REQUEST_UPLOAD = 900;

    private Feature feature;
    private String mCurrentPhotoPath;
    private String[] sources;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_attachments);

        AppUtil.initActivity(this);

        Session session = Session.getSession();
        feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());

        ListAdapter adapter = new AttachmentAdapter(this, feature.getAttachments());
        getListView().setAdapter(adapter);

        getListView().setOnItemClickListener(this);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {

        Session.getSession().setSelectedAttachmentIndex(position);
        Attachment attachment = feature.getAttachments().get(position);

        if (attachment.getType().equalsIgnoreCase("audio")) {
            Intent intent = new Intent(this, AudioAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }
        else if (attachment.getType().equalsIgnoreCase("image")) {
            Intent intent = new Intent(this, ImageAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }
        if (attachment.getType().equalsIgnoreCase("video")) {
            Intent intent = new Intent(this, VideoAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }
        if (attachment.getType().equalsIgnoreCase("text")) {
            Intent intent = new Intent(this, TextAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }



    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.attachments, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_attachment_add) {
            addAttachment();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void addAttachment() {

        List<String> sourcesList = new ArrayList<String>();

        if (getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA_ANY)) {
            sourcesList.add(SOURCE_IMAGE_NEW);
        }
        sourcesList.add(SOURCE_IMAGE_EXISTING);
        sourcesList.add(SOURCE_TEXT_NEW);
        sourcesList.add(SOURCE_AUDIO_NEW);
        sourcesList.add(SOURCE_AUDIO_EXISTING);
        if (getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA_ANY)) {
            sourcesList.add(SOURCE_VIDEO_NEW);
        }
        sourcesList.add(SOURCE_VIDEO_EXISTING);

        sources = new String[sourcesList.size()];
        sourcesList.toArray(sources);

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Attach What?");
        builder.setItems(sources, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                //Toast.makeText(AttachmentsActivity.this, "You selected " + sources[i], Toast.LENGTH_LONG).show();

                String source = sources[i];
                if (source.equals(SOURCE_IMAGE_NEW)) {
                    dispatchTakePictureIntent();
                }
                else if (source.equals(SOURCE_IMAGE_EXISTING)) {
                    Intent intent = new Intent(Intent.ACTION_PICK, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                    if (intent.resolveActivity(getPackageManager()) != null) {
                        startActivityForResult(intent, REQUEST_IMAGE_EXISTING);
                    }
                }
                else if (source.equals(SOURCE_TEXT_NEW)) {
                    Intent intent = new Intent(AttachmentsActivity.this, TextAttachmentActivity.class);
                    startActivityForResult(intent, REQUEST_TEXT_NEW);
                }
                else if (source.equals(SOURCE_AUDIO_NEW)) {
                    Intent intent = new Intent(AttachmentsActivity.this, AudioAttachmentActivity.class);
                    startActivityForResult(intent, REQUEST_AUDIO_NEW);
                }
                else if (source.equals(SOURCE_AUDIO_EXISTING)) {
                    Intent intent = new Intent(Intent.ACTION_PICK, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
                    if (intent.resolveActivity(getPackageManager()) != null) {
                        startActivityForResult(intent, REQUEST_AUDIO_EXISTING);
                    }
                }
                else if (source.equals(SOURCE_VIDEO_NEW)) {
                    dispatchTakeVideoIntent();
                }
                else if (source.equals(SOURCE_VIDEO_EXISTING)) {
                    Intent intent = new Intent(Intent.ACTION_PICK, MediaStore.Video.Media.EXTERNAL_CONTENT_URI);
                    if (intent.resolveActivity(getPackageManager()) != null) {
                        startActivityForResult(intent, REQUEST_VIDEO_EXISTING);
                    }
                }
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();

    }

    private File createImageFile() throws IOException {
        // Create an image file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "OM_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_PICTURES);
        File image = File.createTempFile(
                imageFileName,  /* prefix */
                ".jpg",         /* suffix */
                storageDir      /* directory */
        );

        return image;
    }

    private void dispatchTakePictureIntent() {
        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        // Ensure that there's a camera activity to handle the intent
        if (takePictureIntent.resolveActivity(getPackageManager()) != null) {
            // Create the File where the photo should go
            File photoFile = null;
            try {
                photoFile = createImageFile();
            } catch (IOException ex) {
                GuiUtil.showError(this, ex.getLocalizedMessage());

            }
            // Continue only if the File was successfully created
            if (photoFile != null) {
                mCurrentPhotoPath = photoFile.getAbsolutePath();    //save for later use
                takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT,
                        Uri.fromFile(photoFile));
                startActivityForResult(takePictureIntent, REQUEST_IMAGE_NEW);
            }
        }
    }

    private void dispatchTakeVideoIntent() {
        Intent takeVideoIntent = new Intent(MediaStore.ACTION_VIDEO_CAPTURE);
        if (takeVideoIntent.resolveActivity(getPackageManager()) != null) {
            startActivityForResult(takeVideoIntent, REQUEST_VIDEO_NEW);
        }
    }

    private void galleryAddPic() {
        Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
        File f = new File(mCurrentPhotoPath);
        Uri contentUri = Uri.fromFile(f);
        mediaScanIntent.setData(contentUri);
        this.sendBroadcast(mediaScanIntent);
    }

    //scale image while decoding so that it does not waste memory
    /*
    private void setPic() {
        // Get the dimensions of the View
        int targetW = mImageView.getWidth();
        int targetH = mImageView.getHeight();

        // Get the dimensions of the bitmap
        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
        bmOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(mCurrentPhotoPath, bmOptions);
        int photoW = bmOptions.outWidth;
        int photoH = bmOptions.outHeight;

        // Determine how much to scale down the image
        int scaleFactor = Math.min(photoW/targetW, photoH/targetH);

        // Decode the image file into a Bitmap sized to fill the View
        bmOptions.inJustDecodeBounds = false;
        bmOptions.inSampleSize = scaleFactor;
        bmOptions.inPurgeable = true;

        Bitmap bitmap = BitmapFactory.decodeFile(mCurrentPhotoPath, bmOptions);
        mImageView.setImageBitmap(bitmap);
    }
    */

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == REQUEST_IMAGE_NEW) {
            if (resultCode == RESULT_OK) {

                GuiUtil.fixRotationForCameraImage(this, mCurrentPhotoPath);

                //galleryAddPic();
                Intent editIntent = new Intent(this, EditImageAttachmentActivity.class);
                editIntent.putExtra(EditImageAttachmentActivity.EXTRA_FILE_PATH, mCurrentPhotoPath);
                startActivityForResult(editIntent, REQUEST_UPLOAD);
            }
        }
        else if(requestCode == REQUEST_VIDEO_NEW) {
            if (resultCode == RESULT_OK) {
                Uri videoUri = intent.getData();

            }
        }
        else if (requestCode == REQUEST_VIEW || requestCode == REQUEST_UPLOAD) {
            if (resultCode == RESULT_OK) {
                refreshAttachments();
            }
        }
    }

    private void refreshAttachments() {
        AttributesByPrimaryIdRequest request = new AttributesByPrimaryIdRequest();
        request.setShowAttachments(true);
        request.setLayerId(Session.getSession().getCurrentActiveLayer().getId());
        request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());

        AttributesService service = new AttributesService();
        service.getAttributesByPrimaryId(request, this);
    }

    @Override
    public void featuresCompleted(FeaturesResponse response) {
        try {
            List<Attachment> attachments = response.getItems().getFeatures().get(0).getAttachments();
            feature.setAttachments(attachments);

            ListAdapter adapter = new AttachmentAdapter(this, feature.getAttachments());
            getListView().setAdapter(adapter);
        }
        catch (Exception e) {
            GuiUtil.showError(this, "Could not refresh attachments. " + e.getLocalizedMessage());
        }

    }

    @Override
    public void featuresFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    private class AttachmentAdapter extends ArrayAdapter<Attachment> {

        private Context context;
        private List<Attachment> attachments;

        public AttachmentAdapter(Context context, List<Attachment> attachments) {
            super(context, R.layout.attachment_item);

            this.context = context;
            this.attachments = attachments;
        }

        @Override
        public int getCount() {
            return attachments.size();
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            View view = convertView;

            if (view == null) {
                LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                view = inflater.inflate(R.layout.attachment_item, parent, false);
            }

            ImageView iconView = (ImageView)view.findViewById(R.id.icon);
            TextView firstLineView = (TextView)view.findViewById(R.id.firstLine);
            TextView secondLineView = (TextView)view.findViewById(R.id.secondLine);

            Attachment attachment = attachments.get(position);

            firstLineView.setText(attachment.getCaption());
            secondLineView.setText(attachment.getDescription());

            if (attachment.getType() != null) {
                if (attachment.getType().equalsIgnoreCase("audio")) {
                    iconView.setImageResource(R.drawable.audio);
                } else if (attachment.getType().equalsIgnoreCase("video")) {
                    iconView.setImageResource(R.drawable.video);
                } else if (attachment.getType().equalsIgnoreCase("image")) {
                    iconView.setImageResource(R.drawable.image);
                } else if (attachment.getType().equalsIgnoreCase("text")) {
                    iconView.setImageResource(R.drawable.text);
                } else {
                    Toast.makeText(AttachmentsActivity.this, "Unknown file type " + attachment.getType(), Toast.LENGTH_SHORT).show();
                }
            }

            return view;
        }
    }
}
