package org.quidity.demo.activity;

import android.app.ListActivity;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;

import java.util.ArrayList;
import java.util.List;

public class ActiveLayerActivity extends ListActivity {

    private List<Layer> selectableLayers;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        AppUtil.initActivity(this);

        determineSelectableLayers();

        ListAdapter adapter = new ArrayAdapter<Layer>(this, android.R.layout.simple_list_item_single_choice, selectableLayers);
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        Session session = Session.getSession();
        int currentActiveLayerIndex = selectableLayers.indexOf(session.getCurrentActiveLayer());
        getListView().setItemChecked(currentActiveLayerIndex, true);

    }


    private void determineSelectableLayers() {
        selectableLayers = new ArrayList<Layer>();

        for(Layer layer : Session.getSession().getLayers()) {
            if (!layer.getBaseLayer()) {
                if (layer.isVisibility()) {
                    if (layer.getLayerType().toLowerCase().equalsIgnoreCase("vector")) {
                        selectableLayers.add(layer);
                    }
                }
            }
        }
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        Layer selectedLayer = selectableLayers.get(position);

        Session.getSession().setCurrentActiveLayer(selectedLayer);
        finish();
    }
}
