package org.quidity.demo;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class Settings {

    public static final String MAPI_BASE_URL = "http://www.1map.co.za/mobile";
    public static final String MAPI_AUTH_URL = MAPI_BASE_URL + "/auth";
    public static final String MAPI_PARAMS_URL = MAPI_BASE_URL + "/params";
    public static final String MAPI_ATTRIBUTES_URL = MAPI_BASE_URL + "/attributes";
    public static final String MAPI_SPATIAL_URL = MAPI_BASE_URL + "/spatial";
    public static final String MAPI_TRACKING_URL = MAPI_BASE_URL + "/tracking";

    public static final int SPEED_SLOW_DRIVE = 20;
    public static final int SPEED_FAST_DRIVE = 90;

    public static final int ZOOM_LEVEL_DEFAULT = 17;        //when standing still or walking
    public static final int ZOOM_LEVEL_SLOW_DRIVE = 16;
    public static final int ZOOM_LEVEL_FAST_DRIVE = 15;

    public static final boolean DISABLE_GOOGLE_LAYERS = true;

    private static Settings settings;
    private static final String PREFERENCES_NAME = "1Map";
    private static final String AUTO_ZOOM_KEY = "AutoZoom";
    private static final String KEEP_SCREEN_ON_KEY = "KeepScreenOn";
    private static final String PREVIOUS_USERNAME_KEY = "PreviousUsername";
    private static final String LOG_LOCATION_KEY = "LogLocation";
    private static final String LOG_LOCATION_INTERVAL_KEY = "LogLocationInterval";
    private static final String CAPTURE_IMAGE_LOCATION_KEY = "CaptureImageLocation";
    private static final String DESIRED_ACCURACY_KEY = "DesiredAccuracy";

    private SharedPreferences preferences;
    private boolean autoZoomEnabled;
    private boolean keepScreenOn;
    private boolean logLocation;
    private int logLocationInterval;
    private boolean captureImageLocation;
    private int desiredAccuracy;
    private String previousUsername;

    private Settings() {
        //singleton
    }

    public static Settings getSettings(Context context) {
        if (settings == null) {
            settings = new Settings();
            settings.loadSettings(context);
        }
        return settings;
    }

    private void loadSettings(Context context) {
        preferences = context.getSharedPreferences(PREFERENCES_NAME, Context.MODE_PRIVATE);
        this.autoZoomEnabled = preferences.getBoolean(AUTO_ZOOM_KEY, true);
        this.keepScreenOn = preferences.getBoolean(KEEP_SCREEN_ON_KEY, true);
        this.logLocation = preferences.getBoolean(LOG_LOCATION_KEY, true);
        this.logLocationInterval = preferences.getInt(LOG_LOCATION_INTERVAL_KEY, 10);
        this.captureImageLocation = preferences.getBoolean(CAPTURE_IMAGE_LOCATION_KEY, true);
        this.desiredAccuracy = preferences.getInt(DESIRED_ACCURACY_KEY, 10);
        this.previousUsername = preferences.getString(PREVIOUS_USERNAME_KEY, "");
    }

    public boolean isAutoZoomEnabled() {
        return autoZoomEnabled;
    }

    public void setAutoZoomEnabled(boolean autoZoomEnabled) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(AUTO_ZOOM_KEY, autoZoomEnabled);
        editor.commit();

        this.autoZoomEnabled = autoZoomEnabled;
    }

    public boolean isKeepScreenOn() {
        return keepScreenOn;
    }

    public void setKeepScreenOn(boolean keepScreenOn) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(KEEP_SCREEN_ON_KEY, keepScreenOn);
        editor.commit();

        this.keepScreenOn = keepScreenOn;

    }

    public boolean isLogLocation() {
        return logLocation;
    }

    public void setLogLocation(boolean logLocation) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(LOG_LOCATION_KEY, logLocation);
        editor.commit();

        this.logLocation = logLocation;
    }

    public int getLogLocationInterval() {
        return logLocationInterval;
    }

    public void setLogLocationInterval(int logLocationInterval) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(LOG_LOCATION_INTERVAL_KEY, logLocationInterval);
        editor.commit();

        this.logLocationInterval = logLocationInterval;
    }

    public boolean isCaptureImageLocation() {
        return captureImageLocation;
    }

    public void setCaptureImageLocation(boolean captureImageLocation) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(CAPTURE_IMAGE_LOCATION_KEY, captureImageLocation);
        editor.commit();

        this.captureImageLocation = captureImageLocation;
    }

    public int getDesiredAccuracy() {
        return desiredAccuracy;
    }

    public void setDesiredAccuracy(int desiredAccuracy) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(DESIRED_ACCURACY_KEY, desiredAccuracy);
        editor.commit();

        this.desiredAccuracy = desiredAccuracy;
    }


    public String getPreviousUsername() {
        return previousUsername;
    }

    public void setPreviousUsername(String previousUsername) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(PREVIOUS_USERNAME_KEY, previousUsername);
        editor.commit();

        this.previousUsername = previousUsername;
    }

}
