package org.quidity.demo;

import java.util.List;

import org.quidity.demo.activity.OneMapJavascriptInterface;
import org.quidity.demo.activity.OpenLayersMapActivity;
import org.quidity.demo.mapi.attributes.Feature;
import org.quidity.demo.mapi.auth.Workspace;
import org.quidity.demo.mapi.params.EditTemplate;
import org.quidity.demo.mapi.params.Layer;

/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class Session {

    public static final String EDIT_MODE_CREATE = "CREATE";
    public static final String EDIT_MODE_UPDATE = "UPDATE";

    private String token;
    private String serial;
    private List<Workspace> workspaces;
    private List<Layer> layers;
    private Workspace currentWorkspace;
    private Layer currentBaseLayer;
    private Layer currentActiveLayer;
    private OneMapJavascriptInterface javascriptInterface;
    private int orientation;
    private List<Feature> selectedFeatures;
    private int selectedFeatureIndex;
    private EditTemplate currentEditTemplate;
    private String editMode;
    private int selectedAttachmentIndex;
    private double currentLatitude;
    private double currentLongitude;
    private Layer selectedLayer;


    public OneMapJavascriptInterface getJavascriptInterface(OpenLayersMapActivity mapActivity) {
        if (javascriptInterface == null) {
            javascriptInterface = new OneMapJavascriptInterface(mapActivity);
        }
        return javascriptInterface;
    }


    private static Session session;

    public static Session getSession() {
        if (session == null) {
            session = new Session();
        }
        return session;
    }

    public static void resetSession() {
        session = null;
    }




    private Session() {
        //singleton
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSerial() {
        return serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public List<Workspace> getWorkspaces() {
        return workspaces;
    }

    public void setWorkspaces(List<Workspace> workspaces) {
        this.workspaces = workspaces;
    }

    public List<Layer> getLayers() {
        return layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public Workspace getCurrentWorkspace() {
        return currentWorkspace;
    }

    public void setCurrentWorkspace(Workspace currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }

    public Layer getCurrentBaseLayer() {
        return currentBaseLayer;
    }

    public void setCurrentBaseLayer(Layer currentBaseLayer) {
        this.currentBaseLayer = currentBaseLayer;
    }

    public Layer getCurrentActiveLayer() {
        return currentActiveLayer;
    }

    public void setCurrentActiveLayer(Layer currentActiveLayer) {
        this.currentActiveLayer = currentActiveLayer;
    }

    public int getOrientation() {
        return orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public List<Feature> getSelectedFeatures() {
        return selectedFeatures;
    }

    public void setSelectedFeatures(List<Feature> selectedFeatures) {
        this.selectedFeatures = selectedFeatures;
    }

    public EditTemplate getCurrentEditTemplate() {
        return currentEditTemplate;
    }

    public void setCurrentEditTemplate(EditTemplate currentEditTemplate) {
        this.currentEditTemplate = currentEditTemplate;
    }

    public int getSelectedFeatureIndex() {
        return selectedFeatureIndex;
    }

    public void setSelectedFeatureIndex(int selectedFeatureIndex) {
        this.selectedFeatureIndex = selectedFeatureIndex;
    }

    public String getEditMode() {
        return editMode;
    }

    public void setEditMode(String editMode) {
        this.editMode = editMode;
    }

    public int getSelectedAttachmentIndex() {
        return selectedAttachmentIndex;
    }

    public void setSelectedAttachmentIndex(int selectedAttachmentIndex) {
        this.selectedAttachmentIndex = selectedAttachmentIndex;
    }

    public double getCurrentLongitude() {
        return currentLongitude;
    }

    public void setCurrentLongitude(double currentLongitude) {
        this.currentLongitude = currentLongitude;
    }

    public double getCurrentLatitude() {
        return currentLatitude;
    }

    public void setCurrentLatitude(double currentLatitude) {
        this.currentLatitude = currentLatitude;
    }

    public Layer getSelectedLayer() {
        return selectedLayer;
    }

    public void setSelectedLayer(Layer selectedLayer) {
        this.selectedLayer = selectedLayer;
    }
}
