var map;
var gmap;   //Google Map
var saExtent;
//var currentLayer;
var serial;
var token;
var projection;
var marker;
var resultMarker;
var zoomLevel = 17;     //default zoom level
var vectorLayer;

var resolutions = [156543.033928041,
                     78271.51696402048,
                     39135.75848201023,
                     19567.87924100512,
                     9783.93962050256,
                     4891.96981025128,
                     2445.98490512564,
                     1222.99245256282,
                     611.49622628141,
                     305.7481131407048,
                     152.8740565703525,
                     76.43702828517624,
                     38.21851414258813,
                     19.10925707129406,
                     9.554628535647032,
                     4.777314267823516,
                     2.388657133911758,
                     1.194328566955879,
                     0.5971642834779395,
                     0.29858214173896974,
                     0.14929107086948487
                    ];

var scales = [524288000,
                131072000,
                65536000,
                32768000,
                16384000,
                8192000,
                4096000,
                2048000,
                1024000,
                512000,
                256000,
                128000,
                64000,
                32000,
                16000,
                8000,
                4000,
                2000,
                1000,
                500,
                250
               ];

function test() {
    initMap(4380, '30f4d411fdc71a53362b3bee3d7948d727d69b5e');
    //addOSMLayer();

    //addWMSLayer(1, 'Test attribution', false, 1, 16000, 1, 'erven');  //1map erven
    addWMSLayer(2, 'Test attribution', true, 1, 10000000, 1, '');
    addWMSLayer(330, '&copy; <a href="http://www.1map.co.za/copyright" target="_blank">1map Spatial Solutions (Pty) Ltd</a>', false, 1, 100000000, 1.0, 'point');
    zoomToPoint(-25.808611, 28.256111);
    //removeAllLayers();
    
    //testVectorLayer();
}

function saveState() {
    console.log('Saving current map state');
    
    var coord = ol.proj.transform(map.getView().getCenter(), 'EPSG:900913', 'EPSG:4326');
    var longitude = coord[0];
    var latitude = coord[1];
    Android.setCurrentLongitude(longitude);
    Android.setCurrentLatitude(latitude);
    
    var zoomLevel = map.getView().getZoom();
    Android.setCurrentZoomLevel(zoomLevel);
}

function addGoogleLayer(layerType) {
    console.log('Adding google layer ' + layerType);
    
    var mapType = google.maps.MapTypeId.ROADMAP; //default

    if (layerType === 'googlestreet') {
        mapType = google.maps.MapTypeId.ROADMAP; 
    }
    else if(layerType === 'googlesatellite') {
        mapType = google.maps.MapTypeId.SATELLITE; 
    }
    else if(layerType === 'googlehybrid') {
        mapType = google.maps.MapTypeId.HYBRID; 
    }
    else if(layerType === 'googlephysical') {
        mapType = google.maps.MapTypeId.TERRAIN; 
    }

    var gmapDiv = document.getElementById('gmap');
        
    gmap = new google.maps.Map(gmapDiv, {
      disableDefaultUI: true,
      keyboardShortcuts: false,
      draggable: false,
      disableDoubleClickZoom: true,
      scrollwheel: false,
      streetViewControl: false,
      mapTypeId: mapType
    });      


    var view = map.getView();
    view.on('change:center', function() {
      var center = ol.proj.transform(view.getCenter(), 'EPSG:3857', 'EPSG:4326');
      gmap.setCenter(new google.maps.LatLng(center[1], center[0]));
    });
    view.on('change:resolution', function() {
      gmap.setZoom(view.getZoom());
    });       

    var mapDiv = document.getElementById('map');            
    mapDiv.parentNode.removeChild(mapDiv);
    gmap.controls[google.maps.ControlPosition.TOP_LEFT].push(mapDiv);            

}

function showMarker(latitude, longitude) {

    if(marker == null) {
        console.log('Create marker overlay');
        var markerEl = document.getElementById('geolocation_marker');
        marker = new ol.Overlay({
          positioning: 'center-center',
          element: markerEl,
          stopEvent: true
        });
        map.addOverlay(marker);                            
    }

    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    marker.setPosition(coord);

}

function showResultMarker(latitude, longitude) {

    if(resultMarker == null) {
        console.log('Create result marker overlay');
        var markerEl = document.getElementById('result_marker');
        resultMarker = new ol.Overlay({
          positioning: 'center-center',
          element: markerEl,
          stopEvent: true
        });
        map.addOverlay(resultMarker);                            
    }

    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    resultMarker.setPosition(coord);

}


function hideMarker() {
    console.log('Hide marker');

    //map.removeOverlay(marker);     
    //marker = null;

    //Hack
    var coord = ol.proj.transform([0, 0], 'EPSG:4326', 'EPSG:900913');
    marker.setPosition(coord);

}

function rotateMarker(deg) {
    var div = document.getElementById('geolocation_marker');

    div.style.webkitTransform = 'rotate('+deg+'deg)'; 
    div.style.mozTransform    = 'rotate('+deg+'deg)'; 
    div.style.msTransform     = 'rotate('+deg+'deg)'; 
    div.style.oTransform      = 'rotate('+deg+'deg)'; 
    div.style.transform       = 'rotate('+deg+'deg)'; 

}

function rotateTo(radians) {
        var rotateAnimation = ol.animation.rotate({
            duration: 200, 
            rotation: map.getView().getRotation()
        });
        map.beforeRender(rotateAnimation);
        //map.getView().setRotation(radials * Math.PI);            
        map.getView().setRotation(radians);            
}

function initMap(serial, token) {
    console.log('Init map');
    this.serial = serial;
    this.token = token;

    projection = new ol.proj.Projection({
          code: 'EPSG:900913',
          units: 'm'
    });
    ol.proj.addProjection(projection);            

    saExtent = ol.proj.transform([15.3, -35.16, 35.4, -21.2], 'EPSG:4326', 'EPSG:900913');

    var mapView = new ol.View({
        projection : projection,
        center: ol.proj.transform([18.41970, -33.92212], 'EPSG:4326', 'EPSG:900913'),
        resolutions: resolutions,
        minResolution: 0.14929107086948487, 
        maxResolution: 156543.033928041,
        minZoom: 0,
        maxZoom: 20,
        zoom: 17
    });                

  map = new ol.Map({
    target: 'map',
    layers: [ ],          
    view: mapView,             
  });

    var scaleControl = new ol.control.ScaleLine();
    map.addControl(scaleControl);

    //map.getView().fitExtent(saExtent, map.getSize());

    //forward map click events to Android
    map.on('singleclick', function(evt) {
        var coord = ol.proj.transform(evt.coordinate, 'EPSG:900913', 'EPSG:4326');
        var longitude = coord[0];
        var latitude = coord[1];
        
        Android.mapClicked(latitude, longitude);
    });
    
}

function removeAllLayers() {
    console.log('Removing all layers');
    var layers = map.getLayers();    
    var i;
    var noOfLayers = layers.getLength();
    console.log('Number of layers: ' + noOfLayers);
    for(i = 0; i < noOfLayers; i++) {
        var layer = layers.item(i);
        console.log('Removing layer ' + i);
        map.removeLayer(layer);
    }

}

function addWMSLayer(layerId, attributionsHtml, isBaseLayer, minScale, maxScale, opacity, style) {
    console.log('Add WMS layer ' + layerId + " with style " + style);

    var closestMinScaleIndex = closestIndex(scales, minScale);
    var closestMaxScaleIndex = closestIndex(scales, maxScale);    
    var minResolution = resolutions[closestMinScaleIndex];
    var maxResolution = resolutions[closestMaxScaleIndex];
    
    console.log('minScale: ' + minScale);
    console.log('closestMinScaleIndex: ' + closestMinScaleIndex);
    console.log('minResolution: ' + minResolution);
    
    console.log('maxScale: ' + maxScale);
    console.log('closestMaxScaleIndex: ' + closestMaxScaleIndex);
    console.log('maxResolution: ' + maxResolution);
    
    var wmsLayer = new ol.layer.Tile({
        source              : new ol.source.TileWMS({
            url             : 'http://www.1map.co.za/mobile/spatial/get/tile',                                 // Base URL
            attributions    : [new ol.Attribution({html: attributionsHtml})],    // attributions
            params: {
                'serial'    : this.serial,                                                                            // serial
                'token'     : this.token,                                      // token
                'layerid'   : layerId,                                                                               // layerid
                'isbaselayer' : isBaseLayer                                                                         // isbaselayer

            },
            tileGrid: new ol.tilegrid.TileGrid({
                origin      : [-20037508.34,-20037508.34],
                resolutions : resolutions
            }),
            hidpi           : false,
            serverType      : 'geoserver'
        }),
        extent              : saExtent,                                                                         // extent of South Africa
        minResolution       : minResolution,                                                                           
        maxResolution       : maxResolution,                                                                    
        visible             : true,                                                                             // visibility
        opacity             : opacity                                                                                 // opacity
    });             
    
    //1 to 500

    /*
    if(currentLayer != null) {
        map.removeLayer(currentLayer);
    }
    */

    map.addLayer(wmsLayer);
    //currentLayer = wmsLayer;

}


function addOSMLayer() {
    console.log('Add OSM layer');


    var osmLayer = new ol.layer.Tile({
        source: new ol.source.OSM()
    });

    /*
    if(currentLayer != null) {
        map.removeLayer(currentLayer);
    }
    */

    map.addLayer(osmLayer);
    //currentLayer = osmLayer;
}


function zoomToPoint(latitude, longitude) {
    console.log('Zoom to point ' + latitude + ', ' + longitude);
    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    var view = map.getView();
    view.setCenter(coord);            

    var zoom = ol.animation.zoom({
      resolution: map.getView().getResolution()
    });
    map.beforeRender(zoom);            
    view.setZoom(zoomLevel);
}

function moveToPoint(latitude, longitude) {
    console.log('Move to point ' + latitude + ', ' + longitude);
    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    var view = map.getView();
    view.setCenter(coord);            
}

function setZoomLevel(newZoomLevel) {
    console.log('Set zoom level to ' + newZoomLevel);
    zoomLevel = newZoomLevel;
}


function addVectorLayer(geoJsonStr) {
    console.log('Adding vector layer from GeoJson (stringified):');
    
    var geoJson = JSON.parse(geoJsonStr);
    
    console.log(JSON.stringify(geoJson));
    
    
    var image = new ol.style.Circle({
      radius: 20,
      fill: null,
      stroke: new ol.style.Stroke({color: 'red', width: 3})
    });

    var styles = {
      'Point': [new ol.style.Style({
        image: image
      })],
      'LineString': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'green',
          width: 1
        })
      })],
      'MultiLineString': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'green',
          width: 1
        })
      })],
      'MultiPoint': [new ol.style.Style({
        image: image
      })],
      'MultiPolygon': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'yellow',
          width: 1
        }),
        fill: new ol.style.Fill({
          color: 'rgba(255, 255, 0, 0.1)'
        })
      })],
      'Polygon': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'blue',
          lineDash: [4],
          width: 3
        }),
        fill: new ol.style.Fill({
          color: 'rgba(0, 0, 255, 0.1)'
        })
      })],
      'GeometryCollection': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'magenta',
          width: 2
        }),
        fill: new ol.style.Fill({
          color: 'magenta'
        }),
        image: new ol.style.Circle({
          radius: 10,
          fill: null,
          stroke: new ol.style.Stroke({
            color: 'magenta'
          })
        })
      })],
      'Circle': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'red',
          width: 2
        }),
        fill: new ol.style.Fill({
          color: 'rgba(255,0,0,0.2)'
        })
      })]
    };

    var styleFunction = function(feature, resolution) {
      return styles[feature.getGeometry().getType()];
    };    
    
    /*
    var highlightStyleCache = {};

    var styleFunction = function(feature, resolution) {
        
        var text = resolution < 5000 ? feature.get('name') : '';
        if (!highlightStyleCache[text]) {
          highlightStyleCache[text] = [new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: '#f00',
              width: 1
            }),
            fill: new ol.style.Fill({
              color: 'rgba(255,0,0,0.1)'
            }),
            text: new ol.style.Text({
              font: '12px Calibri,sans-serif',
              text: text,
              fill: new ol.style.Fill({
                color: '#000'
              }),
              stroke: new ol.style.Stroke({
                color: '#f00',
                width: 3
              })
            })
          })];
        }
        return highlightStyleCache[text];        
        
    }    
    */
    
    var vectorSource = new ol.source.GeoJSON({
        //projection: 'EPSG:3857',
        projection: projection,
        object: geoJson
    });
    
    /*
    var vectorSource = new ol.source.GeoJSON({
        projection: 'EPSG:3857',
        url: 'http://openlayers.org/en/v3.0.0/examples/data/geojson/countries.geojson'    
    });
    */
    
    if(vectorLayer != null) {
        map.removeLayer(vectorLayer);
    }
    
    vectorLayer = new ol.layer.Vector({  
      source: vectorSource,
      style: styleFunction
    });
    
    
    /*
    if(resultMarker !== null) {
        console.log('Removing result marker overlay.');
        map.removeOverlay(resultMarker);                                
    }
    else {
        console.log('No result marker.');
    }
    */
    
    map.addLayer(vectorLayer);
    
}


/**
* Returns the closest number from a sorted array.
**/
function closest(arr, target) {
    if (!(arr) || arr.length == 0)
        return null;
    if (arr.length == 1)
        return i[0];

    for (var i=1; i<arr.length; i++) {
        // As soon as a number bigger than target is found, return the previous or current
        // number depending on which has smaller difference to the target.
        if (arr[i] > target) {
            var p = arr[i-1];
            var c = arr[i]
            return Math.abs( p-target ) < Math.abs( c-target ) ? p : c;
        }
    }
    // No number in array is bigger so return the last.
    return arr[arr.length-1];
}

/**
* Returns the closest index from a sorted array.
**/
function closestIndex(arr, target) {
    if (!(arr) || arr.length == 0)
        return null;
    if (arr.length == 1)
        return 0;

    for (var i=0; i<arr.length; i++) {
        // As soon as a number smaller than target is found, return the previous or current
        // number depending on which has smaller difference to the target.
        if (arr[i] < target) {
            var p = arr[i-1];
            var c = arr[i];
            
            return Math.abs( p-target ) < Math.abs( c-target ) ? i-1 : i;
        }
    }
    // No number in array is bigger so return the last.
    return arr.length-1;
}



