package za.co.karaboparking.siteinspection.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.view.View;

/**
 * Created by ferdiedanzfuss on 2017/02/13.
 */

public class GUIUtil {

    private static ProgressDialog progressDialog;

    //Must be called when activity is created
    public static void init(Context context) {

        progressDialog = new ProgressDialog(context);
        progressDialog.setCancelable(false);
        progressDialog.setIndeterminate(true);
        progressDialog.setTitle("Please wait");

    }

    public static void showProgress(final String message) {

        //call on main thread
        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {

                progressDialog.setMessage(message);
                if (!progressDialog.isShowing()) {
                    progressDialog.show();
                }

            }
        });

    }

    public static void hideProgress() {

        //call on main thread
        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {

                if (progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }

            }
        });

    }

    public static void showWarning(Context context, String message) {

        showMessage(context, "Warning", message);

    }

    public static void showInfo(Context context, String message) {

        showMessage(context, "Info", message);

    }

    public static void showMessage(final Context context, final String title, final String message) {

        Runnable runnable = new Runnable() {
            @Override
            public void run() {

                AlertDialog dialog = new AlertDialog.Builder(context)
                        .setTitle(title)
                        .setMessage(message)
                        .setPositiveButton("OK", null)
                        .setCancelable(false)
                        .create();
                dialog.show();

            }
        };

        Handler mainHandler = new Handler(Looper.getMainLooper());
        mainHandler.post(runnable);

    }

    public static void showKeyboard(final Activity activity, final View view) {

        //activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);

        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {

                if (view.requestFocus()) {
                    InputMethodManager imm = (InputMethodManager)
                            activity.getSystemService(Context.INPUT_METHOD_SERVICE);
                    imm.showSoftInput(view, InputMethodManager.SHOW_IMPLICIT);
                }

            }
        });

    }

    public static void hideKeyboard(final Activity activity) {

        //activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);

        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {

                InputMethodManager imm = (InputMethodManager)
                        activity.getSystemService(Context.INPUT_METHOD_SERVICE);

                View currectFocusView = activity.getCurrentFocus();
                if (currectFocusView != null) {
                    imm.hideSoftInputFromWindow(currectFocusView.getWindowToken(), 0);
                }

            }
        });



    }

}
