package za.co.karaboparking.siteinspection.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by ferdiedanzfuss on 2017/02/09.
 */

public class Question {

    public enum QuestionType {
        YesNo, Number, Decimal, Text, Date, DateTime, Amount, MultiChoice
    }

    private String name;
    private QuestionType type;
    private Boolean photoRequired;
    private Boolean commentsRequired;
    private String commentsDescription;
    private List<Choice> choices;

    private Boolean boolAnswer;
    private Integer intAnswer;
    private String textAnswer;      //used for Text and MultiChoice
    private String dateAnswer;        //used for Date, Time and DateTime types
    private Double decimalAnswer;   //used for Decimal and Amount types
    private String comments;
    private List<Photo> photos = new ArrayList<>();



    public Question() {
    }

    public Question(String name) {

        this.name = name;
        this.type = QuestionType.MultiChoice;

        List<Choice> choices = new ArrayList<>();
        choices.add(new Choice("Yes"));
        choices.add(new Choice("No"));
        choices.add(new Choice("N/A"));
        this.choices = choices;
    }

    public Question(String name, QuestionType type) {
        this.name = name;
        this.type = type;
    }

    public Question(String name, boolean photoRequired, boolean photoRequiredIfNegative, boolean commentsRequired, boolean commentsRequiredIfNegative, String commentsDescription) {

        this.name = name;
        this.type = QuestionType.MultiChoice;

        List<Choice> choices = new ArrayList<>();

        Choice yesChoice = new Choice("Yes");
        yesChoice.setPhotoRequired(photoRequired);
        yesChoice.setCommentsRequired(commentsRequired);
        choices.add(yesChoice);

        Choice noChoice = new Choice("No");
        noChoice.setPhotoRequired(photoRequiredIfNegative);
        noChoice.setCommentsRequired(commentsRequiredIfNegative);
        choices.add(noChoice);

        choices.add(new Choice("N/A"));
        this.choices = choices;

        this.commentsDescription = commentsDescription;
    }

    public Question(String name, QuestionType type, boolean photoRequired, boolean commentsRequired, String commentsDescription) {
        this.name = name;
        this.type = type;
        this.photoRequired = photoRequired;
        this.commentsRequired = commentsRequired;
        this.commentsDescription = commentsDescription;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getBoolAnswer() {
        return boolAnswer;
    }

    public void setBoolAnswer(Boolean boolAnswer) {
        this.boolAnswer = boolAnswer;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public List<Photo> getPhotos() {
        return photos;
    }

    public void setPhotos(List<Photo> photos) {
        this.photos = photos;
    }

    public QuestionType getType() {
        return type;
    }

    public void setType(QuestionType type) {
        this.type = type;
    }

    public Boolean isPhotoRequired() {
        return photoRequired;
    }

    public void setPhotoRequired(Boolean photoRequired) {
        this.photoRequired = photoRequired;
    }

    public Boolean isCommentsRequired() {
        return commentsRequired;
    }

    public void setCommentsRequired(Boolean commentsRequired) {
        this.commentsRequired = commentsRequired;
    }

    public String getCommentsDescription() {
        return commentsDescription;
    }

    public void setCommentsDescription(String commentsDescription) {
        this.commentsDescription = commentsDescription;
    }


    public Integer getIntAnswer() {
        return intAnswer;
    }

    public void setIntAnswer(Integer intAnswer) {
        this.intAnswer = intAnswer;
    }

    public String getTextAnswer() {
        return textAnswer;
    }

    public void setTextAnswer(String textAnswer) {
        this.textAnswer = textAnswer;
    }

    public String getDateAnswer() {
        return dateAnswer;
    }

    public void setDateAnswer(String dateAnswer) {
        this.dateAnswer = dateAnswer;
    }

    public Double getDecimalAnswer() {
        return decimalAnswer;
    }

    public void setDecimalAnswer(Double decimalAnswer) {
        this.decimalAnswer = decimalAnswer;
    }

    public List<Choice> getChoices() {
        return choices;
    }

    public void setChoices(List<Choice> choices) {
        this.choices = choices;
    }
}
