package za.co.karaboparking.siteinspection.fragment;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import za.co.karaboparking.siteinspection.R;
import za.co.karaboparking.siteinspection.Session;
import za.co.karaboparking.siteinspection.model.Site;
import za.co.karaboparking.siteinspection.util.GUIUtil;

/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link SitesListFragment.OnFragmentInteractionListener} interface
 * to handle interaction events.
 * Use the {@link SitesListFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class SitesListFragment extends Fragment implements View.OnClickListener {
    // TODO: Rename parameter arguments, choose names that match
    // the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    // TODO: Rename and change types of parameters
    private String mParam1;
    private String mParam2;

    private OnFragmentInteractionListener mListener;

    private RecyclerView recyclerView;
    private SitesListener sitesListener;


    public SitesListFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @param param1 Parameter 1.
     * @param param2 Parameter 2.
     * @return A new instance of fragment SitesListFragment.
     */
    // TODO: Rename and change types and number of parameters
    public static SitesListFragment newInstance(String param1, String param2) {
        SitesListFragment fragment = new SitesListFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
        setHasOptionsMenu(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_sites_list, container, false);
        recyclerView = (RecyclerView)view.findViewById(R.id.sites_recycler);

        LinearLayoutManager layoutManager = new LinearLayoutManager(getContext());
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);

        /*
        List<Site> sites = new ArrayList<>();
        for(int c=0;c<1000;c++) {
            Site site = new Site("Site " + c);
            sites.add(site);
        }
        */

        GUIUtil.showProgress("Loading sites");

        FirebaseDatabase db = FirebaseDatabase.getInstance();
        DatabaseReference ref = db.getReference("Sites");

        sitesListener = new SitesListener();
        //ref.addValueEventListener(sitesListener);
        ref.addListenerForSingleValueEvent(sitesListener);

        return view;
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        inflater.inflate(R.menu.sites_menu, menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        if (item.getItemId() == R.id.logout) {
            logout();
            return true;
        }

        return false;
    }

    private void logout() {
        Session.clearSession();

        FirebaseAuth auth = FirebaseAuth.getInstance();
        auth.signOut();
    }

    @Override
    public void onClick(View view) {

        int itemPosition = recyclerView.getChildLayoutPosition(view);
        Site site = sitesListener.sites.get(itemPosition);
        Session.getSession().setSite(site);

        showDetailScreen();

    }

    private void showDetailScreen() {

        SiteDetailFragment fragment = new SiteDetailFragment();
        FragmentTransaction trans = getActivity().getSupportFragmentManager().beginTransaction();
        trans.addToBackStack("Sites");
        trans.replace(R.id.main_container, fragment);
        trans.commit();

    }

    // TODO: Rename method, update argument and hook method into UI event
    public void onButtonPressed(Uri uri) {
        if (mListener != null) {
            mListener.onFragmentInteraction(uri);
        }
    }

    /*
    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            mListener = (OnFragmentInteractionListener) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragmentInteractionListener");
        }
    }
    */

    @Override
    public void onDetach() {
        super.onDetach();
        mListener = null;
    }

    /**
     * This interface must be implemented by activities that contain this
     * fragment to allow an interaction in this fragment to be communicated
     * to the activity and potentially other fragments contained in that
     * activity.
     * <p>
     * See the Android Training lesson <a href=
     * "http://developer.android.com/training/basics/fragments/communicating.html"
     * >Communicating with Other Fragments</a> for more information.
     */
    public interface OnFragmentInteractionListener {
        // TODO: Update argument type and name
        void onFragmentInteraction(Uri uri);
    }

    class SiteViewHolder extends RecyclerView.ViewHolder {

        private TextView nameView;
        private TextView codeView;

        public SiteViewHolder(View itemView) {
            super(itemView);
            nameView = (TextView) itemView.findViewById(R.id.name);
            //nameView = (TextView) itemView.findViewById(android.R.id.text1);
            codeView = (TextView) itemView.findViewById(R.id.code);
        }

    }

    class SitesAdapter extends RecyclerView.Adapter<SiteViewHolder> {

        private List<Site> sites;

        public SitesAdapter(List<Site> sites) {
            this.sites = sites;
        }

        @Override
        public SiteViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = getActivity().getLayoutInflater();
            View itemView = inflater.inflate(R.layout.fragment_sites_item, parent, false);
            //View itemView = inflater.inflate(android.R.layout.simple_list_item_1, parent, false);
            itemView.setOnClickListener(SitesListFragment.this);
            SiteViewHolder holder = new SiteViewHolder(itemView);
            return holder;
        }

        @Override
        public void onBindViewHolder(SiteViewHolder holder, int position) {
            Site site = sites.get(position);
            holder.nameView.setText(site.getName());
            holder.codeView.setText(site.getCode());
        }

        @Override
        public int getItemCount() {
            return sites.size();
        }

    }

    class SitesListener implements ValueEventListener {

        public List<Site> sites = new ArrayList<>();

        @Override
        public void onDataChange(DataSnapshot dataSnapshot) {

            GUIUtil.hideProgress();

            for (DataSnapshot snapshot : dataSnapshot.getChildren()) {
                Site site = snapshot.getValue(Site.class);
                sites.add(site);
            }

            //sort the list
            Collections.sort(sites, new Comparator<Site>() {
                @Override
                public int compare(Site lhs, Site rhs) {
                    return lhs.getName().compareTo(rhs.getName());
                }
            });

            SitesAdapter adapter = new SitesAdapter(sites);
            recyclerView.setAdapter(adapter);
        }

        @Override
        public void onCancelled(DatabaseError databaseError) {

            Log.d(getClass().getCanonicalName(), databaseError.getMessage());

            GUIUtil.hideProgress();

        }
    }

}
