package za.co.karaboparking.siteinspection.fragment;


import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.NumberPicker;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.PropertyName;
import com.google.firebase.database.ValueEventListener;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

import za.co.karaboparking.siteinspection.MainActivity;
import za.co.karaboparking.siteinspection.Manifest;
import za.co.karaboparking.siteinspection.R;
import za.co.karaboparking.siteinspection.Session;
import za.co.karaboparking.siteinspection.Settings;
import za.co.karaboparking.siteinspection.model.Category;
import za.co.karaboparking.siteinspection.model.Inspection;
import za.co.karaboparking.siteinspection.model.Question;
import za.co.karaboparking.siteinspection.model.Questionnaire;
import za.co.karaboparking.siteinspection.model.Site;
import za.co.karaboparking.siteinspection.util.GUIUtil;

/**
 * A simple {@link Fragment} subclass.
 */
public class SiteInspectionFragment extends Fragment implements View.OnClickListener {

    private static final String TAG = SiteInspectionFragment.class.getCanonicalName();
    private static final int REQUEST_LOCATION = 101;


    private TextView siteNameView;
    private TextView inspectionDateView;
    private Spinner typeSpinner;

    private Button startQuestionnaireButton;

    private Date inspectionDate;

    private List<Questionnaire> questionnaires;
    private Questionnaire questionnaire;

    //private Location location;
    //private LocationManager locationManager;


    public SiteInspectionFragment() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_site_inspection2, container, false);

        siteNameView = (TextView)view.findViewById(R.id.site_name);
        inspectionDateView = (TextView)view.findViewById(R.id.inspection_date);
        typeSpinner = (Spinner)view.findViewById(R.id.type);

        startQuestionnaireButton = (Button)view.findViewById(R.id.start_questionnaire_button);
        startQuestionnaireButton.setOnClickListener(this);


        Site site = Session.getSession().getSite();
        siteNameView.setText(site.getName());

        inspectionDate = new Date();
        String dateStr = new SimpleDateFormat(Settings.DATE_FORMAT).format(inspectionDate);
        inspectionDateView.setText(dateStr);

        loadQuestionnaires();

        //Just in case it is running. Eg. when user press Back button
        // It should only start when we click the button
        MainActivity activity = (MainActivity) getActivity();
        activity.stopLocationUpdates();


        return view;
    }

    /*
    private void startLocationFlow() {

        locationManager = (LocationManager) getContext().getSystemService(Context.LOCATION_SERVICE);
        if (getContext().checkSelfPermission(android.Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            requestLocation();
        }
        else {
            Log.d(TAG, "requestPermissions");
            requestPermissions(new String[] {android.Manifest.permission.ACCESS_FINE_LOCATION}, REQUEST_LOCATION);
        }

    }

    private void requestLocation() {
        Log.d(TAG, "requestLocation");
        GUIUtil.showProgress("Determining your location...");
        locationManager.requestSingleUpdate(LocationManager.GPS_PROVIDER, this, null);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_LOCATION) {
            if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                requestLocation();
            }
            else {
                GUIUtil.showWarning(getContext(), "Location permissions denied. This app needs location permission to function.");
            }
        }
    }

    @Override
    public void onLocationChanged(Location location) {
        Log.d(TAG, "Got location fix: " + location.getLatitude() + ", " + location.getLongitude());
        GUIUtil.hideProgress();
        this.location = location;
        startQuestionnaireButton.setEnabled(true);
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
        Log.d(TAG, "onStatusChanged: " + provider + " " + status);
    }

    @Override
    public void onProviderEnabled(String provider) {
        Log.d(TAG, "onProviderEnabled: " + provider);
    }

    @Override
    public void onProviderDisabled(String provider) {
        Log.d(TAG, "onProviderDisabled: " + provider);
    }
    */

    @Override
    public void onClick(View view) {

        if (view == startQuestionnaireButton) {

            //TODO save assessment details

            validateInput();


        }

    }

    private void loadQuestionnaires() {

        Log.d(TAG, "loadQuestionnaires");

        GUIUtil.showProgress("Loading Questionnaires");

        FirebaseDatabase db = FirebaseDatabase.getInstance();

        DatabaseReference ref = db.getReference("Questionnaires");
        ref.addListenerForSingleValueEvent(new ValueEventListener() {
            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {

                GUIUtil.hideProgress();

                questionnaires = new ArrayList<Questionnaire>();

                for (DataSnapshot questionnaireSnapshot : dataSnapshot.getChildren()) {
                    Questionnaire questionnaire = questionnaireSnapshot.getValue(Questionnaire.class);
                    questionnaires.add(questionnaire);
                }

                ArrayAdapter<Questionnaire> adapter = new ArrayAdapter<Questionnaire>(getContext(), android.R.layout.simple_spinner_item, questionnaires);
                adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                typeSpinner.setAdapter(adapter);

                //startLocationFlow();

                startQuestionnaireButton.setEnabled(true);

            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                Log.e(TAG, databaseError.getMessage());
                GUIUtil.hideProgress();
            }
        });

    }


    private void shuffleAndLimitQuestions(Questionnaire questionnaire) {
        List<Question> questions = questionnaire.getQuestions();
        Collections.shuffle(questions);
        questions = questions.subList(0, questionnaire.getRandomQuestions());
        Log.d(TAG, "Number of questions: " + questions.size());
        questionnaire.setQuestions(questions);
    }

    private void shuffleAndLimitQuestionsPerCategory(Questionnaire questionnaire) {
        List<Question> results = new ArrayList<>();

        for (Category category : questionnaire.getCategories()) {
            List<Integer> questionIds = category.getQuestionIds();
            Collections.shuffle(questionIds);
            questionIds = questionIds.subList(0, category.getRandomQuestions());

            for (Integer questionId : questionIds) {
                Question question = questionnaire.getQuestions().get(questionId);
                results.add(question);
            }

        }

        questionnaire.setQuestions(results);
    }


    private void validateInput() {

        Log.d(TAG, "validateInput");

        loadQuestions();
    }


    private void loadQuestions() {

        Log.d(TAG, "loadQuestions");

        FirebaseDatabase db = FirebaseDatabase.getInstance();

        questionnaire = (Questionnaire) typeSpinner.getSelectedItem();
        Session.getSession().setQuestionIndex(0);
        createNewInspection();




//        DatabaseReference ref = db.getReference("Questionnaires/" + questionnaire.getName() + "/questions");
//        ref.addListenerForSingleValueEvent(new ValueEventListener() {
//            @Override
//            public void onDataChange(DataSnapshot dataSnapshot) {
//
//                allQuestions = new ArrayList<Question>();
//
//                for (DataSnapshot sectionSnapshot : dataSnapshot.getChildren()) {
//                    Questionnaire section = sectionSnapshot.getValue(Questionnaire.class);
//                    List<Question> questions = section.getQuestions();
//                    allQuestions.addAll(questions);
//                }
//
//                //Session.getSession().setQuestions(allQuestions);
//                Session.getSession().setQuestionIndex(0);
//
//                createNewInspection();
//
//            }
//
//            @Override
//            public void onCancelled(DatabaseError databaseError) {
//
//            }
//        });

    }


    private void createNewInspection() {

        Log.d(TAG, "createNewInspection");

        final Inspection inspection = new Inspection();

        String inspectionDateStr = new SimpleDateFormat(Settings.DATE_FORMAT).format(inspectionDate);
        inspection.setInspectionDate(inspectionDateStr);

        String inspectionTimeStr = new SimpleDateFormat(Settings.TIME_FORMAT).format(inspectionDate);
        inspection.setInspectionTime(inspectionTimeStr);

        FirebaseAuth auth = FirebaseAuth.getInstance();
        String userId = auth.getCurrentUser().getUid();
        String userName = auth.getCurrentUser().getDisplayName();
        if (userName == null) {
            userName = auth.getCurrentUser().getEmail();
        }
        inspection.setUserId(userId);
        inspection.setUserName(userName);

        //inspection.setQuestions(allQuestions);
        if (questionnaire.getRandomQuestions() != null && questionnaire.getRandomQuestions() > 0) {
            shuffleAndLimitQuestions(questionnaire);
        }
        else if (questionnaire.getCategories() != null && questionnaire.getCategories().size() > 0) {
            shuffleAndLimitQuestionsPerCategory(questionnaire);
        }
        inspection.setQuestionnaire(questionnaire);

        Site site = Session.getSession().getSite();
        inspection.setSiteCode(site.getCode());

        /*
        if (location != null) {
            inspection.setLatitude(location.getLatitude());
            inspection.setLongitude(location.getLongitude());
            inspection.setAccuracy(location.getAccuracy());
        }
        */

        saveInspection(inspection);

    }

    private void saveInspection(Inspection inspection) {

        Log.d(TAG, "saveInspection");

        //Save to DB
        /*
        FirebaseDatabase db = FirebaseDatabase.getInstance();
        DatabaseReference ref = db.getReference("inspections");
        DatabaseReference inspectionRef = ref.push();
        inspectionRef.setValue(inspection);
        */

        //Save to Sesstion
        Session.getSession().setInspection(inspection);


        showQuestionsScreen();

    }

    private void showQuestionsScreen() {

        Log.d(TAG, "showQuestionsScreen");

        MainActivity activity = (MainActivity) getActivity();
        activity.startLocationUpdates();

        QuestionFragment fragment = new QuestionFragment();
        FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
        ft.addToBackStack("Questions");
        ft.replace(R.id.main_container, fragment).commit();

    }


}
