package za.co.karaboparking.siteinspection.fragment;


import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import java.text.SimpleDateFormat;

import za.co.karaboparking.siteinspection.R;
import za.co.karaboparking.siteinspection.Session;
import za.co.karaboparking.siteinspection.model.Site;

/**
 * A simple {@link Fragment} subclass.
 */
public class SiteDetailFragment extends Fragment implements View.OnClickListener {

    private TextView headingView;
    private TextView nameView;
    private TextView codeView;
    private TextView lastInspectionDateView;
    private TextView lastInspectionUserView;

    private Button newInspectionButton;

    public SiteDetailFragment() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View view = inflater.inflate(R.layout.fragment_site_detail, container, false);

        headingView = (TextView)view.findViewById(R.id.heading);
        nameView = (TextView)view.findViewById(R.id.site_name);
        codeView = (TextView)view.findViewById(R.id.site_code);
        lastInspectionDateView = (TextView)view.findViewById(R.id.last_inspection_date);
        lastInspectionUserView = (TextView)view.findViewById(R.id.last_inspection_user);

        Site site = Session.getSession().getSite();
        headingView.setText(site.getName());
        nameView.setText(site.getName());
        codeView.setText(site.getCode());

        if (site.getLastInspectionUserName() != null) {
            lastInspectionUserView.setText(site.getLastInspectionUserName());
        }

        if (site.getLastInspectionDate() != null) {
            lastInspectionDateView.setText(site.getLastInspectionDate());
        }
        else {
            lastInspectionDateView.setText("Never");
        }



        newInspectionButton = (Button)view.findViewById(R.id.new_inspection_button);
        newInspectionButton.setOnClickListener(this);

        return view;
    }

    @Override
    public void onClick(View view) {

        if (view == newInspectionButton) {
            SiteInspectionFragment fragment = new SiteInspectionFragment();
            FragmentTransaction trans = getActivity().getSupportFragmentManager().beginTransaction();
            trans.addToBackStack("Site Detail");
            trans.replace(R.id.main_container, fragment);
            trans.commit();
        }

    }
}
