package za.co.karaboparking.siteinspection.fragment;

import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;

import org.w3c.dom.Text;

import za.co.karaboparking.siteinspection.DbHelper;
import za.co.karaboparking.siteinspection.R;
import za.co.karaboparking.siteinspection.util.GUIUtil;


/**
 * A simple {@link Fragment} subclass.
 * Activities that contain this fragment must implement the
 * {@link LoginFragment.OnFragmentInteractionListener} interface
 * to handle interaction events.
 * Use the {@link LoginFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class LoginFragment extends Fragment implements View.OnClickListener {

    private static String TAG = LoginFragment.class.getCanonicalName();

    private EditText usernameField;
    private EditText passwordField;
    private Button loginButton;
    private TextView versionView;

    public LoginFragment() {
        // Required empty public constructor
    }

    /**
     * Use this factory method to create a new instance of
     * this fragment using the provided parameters.
     *
     * @return A new instance of fragment LoginFragment.
     */
    public static LoginFragment newInstance() {
        LoginFragment fragment = new LoginFragment();
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_login, container, false);

        usernameField = (EditText)view.findViewById(R.id.username_field);
        passwordField = (EditText)view.findViewById(R.id.password_field);
        loginButton = (Button)view.findViewById(R.id.login_button);
        versionView = (TextView)view.findViewById(R.id.version);

        loginButton.setOnClickListener(this);

        //usernameField.setText("ferdie@mobilica.co.za");
        //passwordField.setText("patches");

        try {
            PackageInfo info = getActivity().getPackageManager().getPackageInfo(getActivity().getPackageName(), 0);
            String versionStr = "v" + info.versionName + " (" + info.versionCode + ")";
            versionView.setText(versionStr);
        }
        catch (Exception e) {
            Log.e(TAG, e.getMessage(), e);
        }


        return view;
    }

    public void loginClicked() {

        String username = usernameField.getText().toString();
        String password = passwordField.getText().toString();

        if (username.trim().length() == 0) {
            GUIUtil.showWarning(getContext(), "Please enter a username.");
            return;
        }

        if (password.trim().length() == 0) {
            GUIUtil.showWarning(getContext(), "Please enter a password");
            return;
        }

        GUIUtil.hideKeyboard(getActivity());

        FirebaseAuth auth = FirebaseAuth.getInstance();
        GUIUtil.showProgress("Logging on...");
        auth.signInWithEmailAndPassword(username, password).addOnCompleteListener(new OnCompleteListener<AuthResult>() {
            @Override
            public void onComplete(@NonNull Task<AuthResult> task) {
                Log.d(TAG, "signInWithEmail:onComplete:" + task.isSuccessful());
                GUIUtil.hideProgress();

                if (!task.isSuccessful()) {
                    Log.w(TAG, "signInWithEmail:failed", task.getException());
                    Toast.makeText(getActivity(), "Authentication failed!",
                            Toast.LENGTH_LONG).show();
                }
            }
        });


    }

    @Override
    public void onClick(View v) {

        if(v == loginButton) {
            loginClicked();
        }

    }
}
