package za.co.karaboparking.siteinspection;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;

import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

import za.co.karaboparking.siteinspection.fragment.LoginFragment;
import za.co.karaboparking.siteinspection.fragment.QuestionFragment;
import za.co.karaboparking.siteinspection.fragment.SitesListFragment;
import za.co.karaboparking.siteinspection.model.Site;
import za.co.karaboparking.siteinspection.util.GUIUtil;

public class MainActivity extends AppCompatActivity implements
        FirebaseAuth.AuthStateListener,
        QuestionFragment.QuestionFragmentListener,
        LocationListener
{

    private static final String TAG = MainActivity.class.getCanonicalName();
    private static final int REQUEST_LOCATION = 202;

    private FirebaseAnalytics analytics;
    private FirebaseAuth auth;

    private Location location;
    private LocationManager locationManager;



    //Firebase initialization - trick to ensure this gets called only once, prevents crash
    //Another (better) solution would be to put this in the Application class
    static {
        FirebaseDatabase db = FirebaseDatabase.getInstance();

        db.setPersistenceEnabled(true);

        DatabaseReference sitesRef = db.getReference(DB.SITES);
        sitesRef.keepSynced(true);

        DatabaseReference questionnairesRef = db.getReference(DB.QUESTIONNAIRES);
        questionnairesRef.keepSynced(true);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Session.getSession().setInitialLoginFlow(true);

        analytics = FirebaseAnalytics.getInstance(this);
        auth = FirebaseAuth.getInstance();

        GUIUtil.init(this);


        //WARNING Should rather be called from onAuthStateChanged - needs to be authenticated first
        //DbHelper helper = new DbHelper();
        //helper.createInitialDb();
    }


    @Override
    protected void onStart() {
        super.onStart();
        auth.addAuthStateListener(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        auth.removeAuthStateListener(this);

    }

    @Override
    public void onAuthStateChanged(@NonNull FirebaseAuth firebaseAuth) {
        if(firebaseAuth.getCurrentUser() == null) {
            showLoginScreen();
        }
        else {
            Log.d(TAG, "User logged in " + firebaseAuth.getCurrentUser().getDisplayName());

            if (Session.getSession().isInitialLoginFlow()) {
                Session.getSession().setInitialLoginFlow(false);
                showSitesListScreen();
            }

//            //DEBUG ONLY - comment out for production
//            DbHelper helper = new DbHelper();
//            helper.createInitialDb();
//            helper.moveInspections("P0043", "P0044");
        }
    }

    private void showLoginScreen() {

        LoginFragment fragment = LoginFragment.newInstance();

        FragmentTransaction ft = getSupportFragmentManager().beginTransaction();
        ft.replace(R.id.main_container, fragment);
        ft.commit();

    }

    private void showSitesListScreen() {
        //TODO
        SitesListFragment fragment = SitesListFragment.newInstance("","");

        FragmentTransaction ft = getSupportFragmentManager().beginTransaction();
        ft.replace(R.id.main_container, fragment);
        ft.commit();


    }


    public void startLocationUpdates() {

        Log.d(TAG, "Starting location updates.");

        locationManager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
        if (checkSelfPermission(android.Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            requestLocation();
        }
        else {
            Log.d(TAG, "requestPermissions");
            requestPermissions(new String[] {android.Manifest.permission.ACCESS_FINE_LOCATION}, REQUEST_LOCATION);
        }

    }

    public void stopLocationUpdates() {
        Log.d(TAG, "Stopping location updates.");
        if (locationManager != null) {
            locationManager.removeUpdates(this);
        }
    }

    private void requestLocation() {
        Log.d(TAG, "requestLocation");
        //locationManager.requestSingleUpdate(LocationManager.GPS_PROVIDER, this, null);
        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, this);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_LOCATION) {
            if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                requestLocation();
            }
            else {
                GUIUtil.showWarning(this, "Location permissions denied. This app needs location permission to function.");
            }
        }
    }

    @Override
    public void onLocationChanged(Location location) {
        Log.d(TAG, "Got location fix: " + location.getLatitude() + ", " + location.getLongitude());
        if (location != null) {
            this.location = location;
        }
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
        Log.d(TAG, "onStatusChanged: " + provider + " " + status);
    }

    @Override
    public void onProviderEnabled(String provider) {
        Log.d(TAG, "onProviderEnabled: " + provider);
    }

    @Override
    public void onProviderDisabled(String provider) {
        Log.d(TAG, "onProviderDisabled: " + provider);
    }

    public Location getLocation() {
        return this.location;
    }


}
