package za.co.karaboparking.siteinspection;

import android.graphics.Path;
import android.util.Log;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;

import java.util.ArrayList;
import java.util.List;

import za.co.karaboparking.siteinspection.model.Category;
import za.co.karaboparking.siteinspection.model.Question;
import za.co.karaboparking.siteinspection.model.Questionnaire;
import za.co.karaboparking.siteinspection.model.Site;

/**
 * Created by ferdiedanzfuss on 2017/02/07.
 */

public class DbHelper {

    public void createInitialDb() {
        
        //createSites();
        //createQuestionnaire();

    }

    private void createSites() {

        Log.d(getClass().getCanonicalName(), "Creating sites..");

        FirebaseDatabase db = FirebaseDatabase.getInstance();
        DatabaseReference sitesRef = db.getReference("Sites");

        //Grace Lauren Smith
        sitesRef.child("P0049").setValue(new Site("P0049", "Central Walk"));
        sitesRef.child("P0048").setValue(new Site("P0048", "Jeff Place"));
        sitesRef.child("P0047").setValue(new Site("P0047", "Prinsman Place"));
        sitesRef.child("P0051").setValue(new Site("P0051", "The Pavilion"));
        sitesRef.child("P0046").setValue(new Site("P0046", "Nedbank Plaza"));
        sitesRef.child("P0032").setValue(new Site("P0032", "Sammy Marks"));
        sitesRef.child("P0035").setValue(new Site("P0035", "City Place"));
        sitesRef.child("P0036").setValue(new Site("P0036", "Govpret"));
        sitesRef.child("P0037").setValue(new Site("P0037", "JSL"));
        sitesRef.child("P0038").setValue(new Site("P0038", "Sophie De Bruyn"));
        sitesRef.child("P0040").setValue(new Site("P0040", "Princhurch"));
        sitesRef.child("P0041").setValue(new Site("P0041", "Volks"));
        sitesRef.child("P0001").setValue(new Site("P0001", "Skinner Street"));

        //Lean Avenant
        sitesRef.child("P0002").setValue(new Site("P0002", "The Promenade"));
        sitesRef.child("P0003").setValue(new Site("P0003", "Bester Brown"));
        sitesRef.child("P0004").setValue(new Site("P0004", "Nedbank Building"));
        sitesRef.child("P0010").setValue(new Site("P0010", "Nelspruit Plaza"));
        sitesRef.child("P0026").setValue(new Site("P0026", "Grand Central"));
        sitesRef.child("P0024").setValue(new Site("P0024", "The Glynwood"));
        sitesRef.child("P0018").setValue(new Site("P0018", "Inner Court"));
        sitesRef.child("P0022").setValue(new Site("P0022", "Vuselela"));
        sitesRef.child("P0023").setValue(new Site("P0023", "Royel Place"));
        sitesRef.child("P0028").setValue(new Site("P0028", "Braamfischer"));
        sitesRef.child("P0029").setValue(new Site("P0029", "Lister Building"));
        sitesRef.child("P0043").setValue(new Site("P0043", "Kempton Square"));
        sitesRef.child("P0013").setValue(new Site("P0013", "Matlosana Mall"));
        sitesRef.child("P0015").setValue(new Site("P0015", "West End"));

        //Stefan Oosthuizen
        sitesRef.child("P0019").setValue(new Site("P0019", "Rivonia Village"));
        sitesRef.child("P0020").setValue(new Site("P0020", "Thrupps Illovo"));
        sitesRef.child("P0025").setValue(new Site("P0025", "24 Central"));
        sitesRef.child("P0027").setValue(new Site("P0027", "The Grove"));
        sitesRef.child("P0017").setValue(new Site("P0017", "MontClare Place"));
        sitesRef.child("P0009").setValue(new Site("P0009", "Randridge Mall"));
        //sitesRef.child("P0043").setValue(new Site("P0043", "Aliwal"));
        sitesRef.child("P0034").setValue(new Site("P0034", "Killarney Mall"));
        sitesRef.child("P0033").setValue(new Site("P0033", "The Sanctuary"));
        sitesRef.child("P0030").setValue(new Site("P0030", "Dainfern Square"));

        //Cilliers
        sitesRef.child("P0021").setValue(new Site("P0021", "Limpopo Mall"));
        sitesRef.child("P0011").setValue(new Site("P0011", "Hatfield Square"));
        sitesRef.child("P0014").setValue(new Site("P0014", "Suncardia"));
        sitesRef.child("P0039").setValue(new Site("P0039", "Praetor"));
        sitesRef.child("P0007").setValue(new Site("P0007", "Poyntons"));
        sitesRef.child("P0016").setValue(new Site("P0016", "Finpark"));
        sitesRef.child("P0012").setValue(new Site("P0012", "The Tramshed"));
        sitesRef.child("P0008").setValue(new Site("P0008", "Fedsure Forum"));
        sitesRef.child("P0045").setValue(new Site("P0045", "The Fields"));
        sitesRef.child("P0005").setValue(new Site("P0005", "Menlyn Square"));
        sitesRef.child("P0031").setValue(new Site("P0031", "Louis Pasteur"));

        //New
        sitesRef.child("P0052").setValue(new Site("P0052", "Mall of the South"));
        sitesRef.child("P0053").setValue(new Site("P0053", "Picbel"));
        sitesRef.child("P0054").setValue(new Site("P0054", "Lynwood Bridge"));
        sitesRef.child("P0050").setValue(new Site("P0050", "Center Place"));

    }

    private void createQuestionnaire() {

        Log.d(getClass().getCanonicalName(), "Creating Questionnaire..");

        FirebaseDatabase db = FirebaseDatabase.getInstance();
        DatabaseReference questionnairesRef = db.getReference("Questionnaires");
        questionnairesRef.setValue(null); //delete everything

        //Pay On Exit
        Questionnaire poe = new Questionnaire("Pay On Exit", 10);
        // STAFF RELATED
        poe.getQuestions().add(new Question("Is the Cashier in Full uniform, including name tag?"));
        poe.getQuestions().add(new Question("Is the Cashier sober, with no smell of alcohol?"));
        poe.getQuestions().add(new Question("Does the Cashier have personal money on him/her?", false, false, true, false, "State Amount"));
        poe.getQuestions().add(new Question("Did the Cashier receive sufficient float?", false, false, false, false, "State Amount"));
        poe.getQuestions().add(new Question("Will this shift start at scheduled time?"));
        poe.getQuestions().add(new Question("Did all staff on duty sign the attendance register?"));
        poe.getQuestions().add(new Question("Did all staff members receive induction training?"));
        poe.getQuestions().add(new Question("Are cashier bleed off - levels determined and implemented?"));
        poe.getQuestions().add(new Question("Is the \"Take Home\" Key procedure in place?"));

        // BOOTH / LANE
        poe.getQuestions().add(new Question("Is both the booth and lane clean?"));
        poe.getQuestions().add(new Question("Are doors, windows, drawers etc in working condition?"));
        poe.getQuestions().add(new Question("Are all signs properly fixed in place, including 'open tariffs' etc."));
        poe.getQuestions().add(new Question("Is intercom / radio working?"));
        poe.getQuestions().add(new Question("Are power boxes sealed?"));
        poe.getQuestions().add(new Question("Are all lights in the booth and lanes working?"));
        poe.getQuestions().add(new Question("Are there any loose, damaged or exposed wires visible?"));
        poe.getQuestions().add(new Question("Is a ticket holder unit available?"));
        poe.getQuestions().add(new Question("Are lighting levels acceptable within the Car Pak?"));
        poe.getQuestions().add(new Question("Any water leakages within the Car Park?"));
        poe.getQuestions().add(new Question("Is Security within the car park visible?"));

        // EQUIPMENT
        poe.getQuestions().add(new Question("Was the fee terminal cleared (z-total taken)?"));
        poe.getQuestions().add(new Question("Are there sufficient audit rolls in the fee terminal?"));
        poe.getQuestions().add(new Question("Is the time & date displayed correctly?"));
        poe.getQuestions().add(new Question("Is the remote display in working order?"));
        poe.getQuestions().add(new Question("Is the Fee Terminal printing clear (audit roll and ticket print)?"));
        poe.getQuestions().add(new Question("Are counters operational?"));
        poe.getQuestions().add(new Question("Is barrier operational and locked?"));
        poe.getQuestions().add(new Question("Is card reader operational?"));
        poe.getQuestions().add(new Question("Are there no metal objects in the lane or on islands?"));

        // SITE MANAGER
        poe.getQuestions().add(new Question("Did the Manager check & sign all daily documents?"));
        poe.getQuestions().add(new Question("Did the Manager perform daily Surprise Cash Checks?"));
        poe.getQuestions().add(new Question("Did the Manager sign the receipt book Daily?"));
        poe.getQuestions().add(new Question("Did the Manager do price checking of a minimum of 500 tickets a day?"));
        poe.getQuestions().add(new Question("Did the Manager count all tickets per cashier and verify it to the KP1 documents?"));
        poe.getQuestions().add(new Question("Did the Manager check all Grace and N/C tickets daily?"));
        poe.getQuestions().add(new Question("Did the Manager check all damaged and test tickets daily?"));
        poe.getQuestions().add(new Question("Did the Manager check all No charge tickets daily?"));
        poe.getQuestions().add(new Question("Did the Manager check and investigate the Missing Tickets daily?"));
        poe.getQuestions().add(new Question("Did the Manager reconcile the Float daily?"));
        poe.getQuestions().add(new Question("Did the Manager complete the Manager Audit checking routine documents daily?"));
        poe.getQuestions().add(new Question("Did the Manager reconcile the Monthly Card system Monthly?"));

        // OPS - CHECKS
        poe.getQuestions().add(new Question("Perform a cash check of one cashier. Did the cash balance to the till slip?"));
        poe.getQuestions().add(new Question("Perform a cash check of one cashier. Are cash floats sufficient and correct?"));
        poe.getQuestions().add(new Question("Perform a cash check of one cashier. Is the TD time synchronised with the Fee computer?"));
        poe.getQuestions().add(new Question("Perform a cash check of one cashier. Are all collected revenues banked the following trading day?"));

        // RECORDS / REGISTER
        poe.getQuestions().add(new Question("Is the OB / Events Book in place and up to date?"));
        poe.getQuestions().add(new Question("Is the Summary Client listing in place and up to date?"));
        poe.getQuestions().add(new Question("Is the Attendance Register / hours worked sheets in place and up to date?"));
        poe.getQuestions().add(new Question("Is the Equipment log book in place and up to date?"));
        poe.getQuestions().add(new Question("Is the Cardkey Register in place and up to date?"));
        poe.getQuestions().add(new Question("Is the No charge / credit casual authorised signature / stamp lists in place and up to date?"));
        poe.getQuestions().add(new Question("Is the Data Back-up register in place and up to date?"));


        questionnairesRef.child("Pay On Exit").setValue(poe);
        //questionnairesRef.push().setValue(poe);


        // Pay On Foot
        Questionnaire pof = new Questionnaire("Pay On Foot", 0);
        List<Category> pofCategories = new ArrayList<>();
        int index = 0;

        Category catEquipment = new Category("Equipment", 7);
        Category catHR = new Category("HR", 5);
        Category catRegister = new Category("Register", 8);
        Category catCheck = new Category("Check", 10);
        Category catDailyDocs = new Category("Daily Docs", 3);
        Category catHousekeeping = new Category("Housekeeping", 2);

        pofCategories.add(catEquipment);
        pofCategories.add(catHR);
        pofCategories.add(catRegister);
        pofCategories.add(catCheck);
        pofCategories.add(catDailyDocs);
        pofCategories.add(catHousekeeping);


        //Equipment
        pof.getQuestions().add(new Question("Number of entry lanes?", Question.QuestionType.Number));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Number of passby's?", Question.QuestionType.Number));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Number of exits?", Question.QuestionType.Number));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Number of pay stations?", Question.QuestionType.Number));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All equipment in the office operational?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Any exposed wires in the office?", true, true, false, false, null));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is there a cashier station?", true, false, false, false, null));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is the cashier station high bright working?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All display screens working on all stations?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All APS providing receipts?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All barriers locked?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All ticket dispensers locked?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All equipment functioning?", false, false, false, true, "What is the problem and ref number?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Did you synchronize the date and time with all stations?"));
        catEquipment.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("When last was a service conducted?", Question.QuestionType.Date, false, false, null));
        catEquipment.getQuestionIds().add(index++);


        //HR
        pof.getQuestions().add(new Question("Is the deployment schedule displayed?", true, false, false, false, null));
        catHR.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("How many staff should be onsite?", Question.QuestionType.Number));
        catHR.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("How many staff curretnly onsite?", Question.QuestionType.Number));
        catHR.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is the approved deployment schedule adhered to?"));
        catHR.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Attendance register signed by CPM, daily?", true, false, false, false, null));
        catHR.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Attendance register signed by operations manager?", true, false, false, false, null));
        catHR.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Are the weekly hours calculated?", true, false, false, false, null));
        catHR.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All staff in full uniform?", true, false, false, false, null));
        catHR.getQuestionIds().add(index++);


        //Register
        pof.getQuestions().add(new Question("Manual boom openings recorded in register?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Overpayments printed and filed? Compare to system"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Last float count done?", Question.QuestionType.Date, false, true, "Results (Short/Over, Amount):"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is a register kept for temper seals?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is an equipment log sheet kept?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is a key register in place?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is a voucher/visitor register in place?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is there an APS door opening register in the APS?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("No charge register in place?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Lost ticket register in place?"));
        catRegister.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is a receipt register in place?"));
        catRegister.getQuestionIds().add(index++);

        //Check
        pof.getQuestions().add(new Question("Number of boom openings corresponds with system report?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Do the current seals, in APS, correspond with the register?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("When opening an APS was it recorded in the control room?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Are there enough tickets onsite?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Total float onsite?", Question.QuestionType.Amount));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Did the Operations Manager conduct a float count?", false, false, true, false, "Results (Short/Over, Amount):"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Was a spot check conducted on the cashier station takings?", false, false, true, false, "Results (Short/Over, Amount):"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Was draining done on the day of visit?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Does the safe changes on peripheral corresponds to the actual count?", false, false, false, true, "What was the issue?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("When last was a drum recon done?", Question.QuestionType.Date, false, true, "Results:"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Do a random drum recon on an APS. Add a picture of peripheral and result.", true, false, true, false, "What APS? Result?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Does the receipt register and receipt book correspond?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Is all the cancelled and manual (casual) receipts recorded and sent to office?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Did the CPM conduct a drum recon in the last two weeks?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Does the float balance?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Does the visitor tickets balance to manual register?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Was an AGE analyst received within the last two weeks?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Was a billing summary received within the last month?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Refills receipts balances to system report and filled?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Does the bank deposit slip balances to KP documents?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Was all access cards blocked according to AGE analyst?"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Recon done on monthly system? Minimum of 15 different accounts"));
        catCheck.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Was the OB signed?"));
        catCheck.getQuestionIds().add(index++);

        //Daily Docs
        pof.getQuestions().add(new Question("KP1 Completed"));
        catDailyDocs.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("KP2 Completed"));
        catDailyDocs.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("KP3 Completed"));
        catDailyDocs.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("KP4 Completed"));
        catDailyDocs.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Confirm that all KP docs were completed correctly"));
        catDailyDocs.getQuestionIds().add(index++);

        //Housekeeping
        pof.getQuestions().add(new Question("All lights in the parking office operational?"));
        catHousekeeping.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Are all the lanes clean and clear?"));
        catHousekeeping.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Car park office clean?"));
        catHousekeeping.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("All equipment neat and tidy?"));
        catHousekeeping.getQuestionIds().add(index++);
        pof.getQuestions().add(new Question("Amount of tickets onsite?", Question.QuestionType.Number));
        catHousekeeping.getQuestionIds().add(index++);


        pof.setCategories(pofCategories);
        questionnairesRef.child("Pay On Foot").setValue(pof);


    }

    public void moveInspections(String fromSiteId, final String toSiteId) {

        Log.d(getClass().getCanonicalName(), "Moving inspections from " + fromSiteId + " to " + toSiteId);

        FirebaseDatabase db = FirebaseDatabase.getInstance();
        DatabaseReference fromRef = db.getReference("Inspections/" + fromSiteId);
        final DatabaseReference toRef = db.getReference("Inspections/" + toSiteId);

        fromRef.addListenerForSingleValueEvent(new ValueEventListener() {
            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                toRef.setValue(dataSnapshot.getValue());
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {

            }
        });

    }
}
